---
Difficulty: Medium  
Source: Daily-Question (POTD 10-Dec)  
Tags:  
- Hash Table
- String
- Binary Search
- Sliding Window
- Counting
---

# 🚀 *2981. Find Longest Special Substring That Occurs Thrice I* 🧠

### Problem Link:
[**LeetCode - Find Longest Special Substring That Occurs Thrice I**](https://leetcode.com/problems/find-longest-special-substring-that-occurs-thrice-i/description/?envType=daily-question&envId=2024-12-10)



## 💡 **Problem Breakdown:**

You are given a string s that consists of lowercase English letters.

A string is called special if it is made up of only a single character. For example, the string "abc" is not special, whereas the strings "ddd", "zz", and "f" are special.

Return the length of the longest special substring of s which occurs at least thrice, or -1 if no special substring occurs at least thrice.

A substring is a contiguous non-empty sequence of characters within a string.

 
### 🔍 **Example Walkthrough:**

Example 1:

Input: s = "aaaa"<br/>
Output: 2<br/>
Explanation: The longest special substring which occurs thrice is "aa": substrings "aaaa", "aaaa", and "aaaa".<br/>
It can be shown that the maximum length achievable is 2.


Example 2:

Input: s = "abcdef"<br/>
Output: -1<br/>
Explanation: There exists no special substring which occurs at least thrice. Hence return -1.<br/>

Example 3:

Input: s = "abcaba"<br/>
Output: 1<br/>
Explanation: The longest special substring which occurs thrice is "a": substrings "abcaba", "abcaba", and "abcaba".<br/>
It can be shown that the maximum length achievable is 1.


### 🔍 **Constraints**

- $3 <= s.length <= 50$
- s consists of only lowercase English letters.



## 🎯 **My Approach**

To efficiently process up to \(10^5\) queries, a brute-force approach is not feasible due to the size constraints. Instead, we use a **preprocessing-based solution** with the following steps:

### **Key Idea:**
Use a **difference array** to track changes in parity mismatches for efficient range checks.

1. **Preprocessing with Parity Mismatch:**  
   Construct an array `is_special[i]` where:  
   - `is_special[i] = 1` if `nums[i]` and `nums[i+1]` have different parities, otherwise `0`.  

2. **Prefix Sum for Range Queries:**  
   Create a prefix sum array `prefix[i]` of the `is_special` array. This allows us to efficiently count mismatches in a given subarray.

3. **Query Processing:**  
   For a query `[fromi, toi]`, the subarray is special if:
   - `prefix[toi - 1] - prefix[fromi - 1] == toi - fromi`



## 🕒 **Complexity Analysis**

- **Preprocessing:**  
  - Constructing `is_special`: \(O(n)\)  
  - Building `prefix`: \(O(n)\)  
- **Query Processing:**  
  - Each query: \(O(1)\) using prefix sums.  
  - Total: \(O(q)\) for \(q\) queries.  
- **Overall:** \(O(n + q)\)  

- **Space Complexity:** \(O(n)\) for `is_special` and `prefix`.
  
### 🕒 **Time Complexity:**
- \(O(n + q)\)  
### 🛠 **Space Complexity:**  
- \(O(n)\)



## 📝 **Solution Code**

## Code (C):

```c
int isValid(const char* s, int n, int x) {
    int freq[26] = {0};
    for (int i = 0; i < n;) {
        int j = i + 1;
        while (j < n && s[j] == s[i]) j++;
        freq[s[i] - 'a'] += (j - i - x + 1) > 0 ? (j - i - x + 1) : 0;
        if (freq[s[i] - 'a'] >= 3) return 1;
        i = j;
    }
    return 0;
}

int maximumLength(char* s) {
    int n = strlen(s), l = 0, r = n;
    while (l < r) {
        int mid = (l + r + 1) / 2;
        if (isValid(s, n, mid)) l = mid;
        else r = mid - 1;
    }
    return l == 0 ? -1 : l;
}
```

## Code (C++)

```cpp
class Solution {
public:
    int maximumLength(string s) {
        int n = s.size(), l = 0, r = n;
        while (l < r) {
            int mid = (l + r + 1) / 2;
            if (isValid(s, n, mid)) l = mid;
            else r = mid - 1;
        }
        return l == 0 ? -1 : l;
    }

private:
    bool isValid(const string& s, int n, int x) {
        vector<int> freq(26, 0);
        for (int i = 0; i < n;) {
            int j = i + 1;
            while (j < n && s[j] == s[i]) j++;
            freq[s[i] - 'a'] += max(0, j - i - x + 1);
            if (freq[s[i] - 'a'] >= 3) return true;
            i = j;
        }
        return false;
    }
};
```

## Code (Java)

```java
class Solution {
    public int maximumLength(String s) {
        int n = s.length(), l = 0, r = n;
        while (l < r) {
            int mid = (l + r + 1) >> 1;
            if (isValid(s, n, mid)) l = mid;
            else r = mid - 1;
        }
        return l == 0 ? -1 : l;
    }

    private boolean isValid(String s, int n, int x) {
        int[] freq = new int[26];
        for (int i = 0; i < n;) {
            int j = i + 1;
            while (j < n && s.charAt(j) == s.charAt(i)) j++;
            freq[s.charAt(i) - 'a'] += Math.max(0, j - i - x + 1);
            if (freq[s.charAt(i) - 'a'] >= 3) return true;
            i = j;
        }
        return false;
    }
}
```

## Code (Python)

```python
class Solution:
    def maximumLength(self, s: str) -> int:
        def is_valid(s, n, x):
            freq = [0] * 26
            i = 0
            while i < n:
                j = i + 1
                while j < n and s[j] == s[i]:
                    j += 1
                freq[ord(s[i]) - ord('a')] += max(0, j - i - x + 1)
                if freq[ord(s[i]) - ord('a')] >= 3:
                    return True
                i = j
            return False
        
        n, l, r = len(s), 0, len(s)
        while l < r:
            mid = (l + r + 1) // 2
            if is_valid(s, n, mid):
                l = mid
            else:
                r = mid - 1
        return -1 if l == 0 else l
```

## Code (Rust)

```rust
impl Solution {
    pub fn maximum_length(s: String) -> i32 {
        fn is_valid(s: &str, n: usize, x: usize) -> bool {
            let mut freq = vec![0; 26];
            let bytes = s.as_bytes();
            let mut i = 0;
            while i < n {
                let mut j = i + 1;
                while j < n && bytes[j] == bytes[i] {
                    j += 1;
                }
                let index = (bytes[i] - b'a') as usize;
                freq[index] += (j - i).saturating_sub(x - 1);
                if freq[index] >= 3 {
                    return true;
                }
                i = j;
            }
            false
        }

        let n = s.len();
        let mut l = 0;
        let mut r = n;
        while l < r {
            let mid = (l + r + 1) / 2;
            if is_valid(&s, n, mid) {
                l = mid;
            } else {
                r = mid - 1;
            }
        }
        if l == 0 { -1 } else { l as i32 }
    }
}
```



## 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
